<?php
###################################
# Responsive Fields
###################################
// Element
Css::margin("#$id", $field['margin']);
Css::padding("#$id", $field['padding']);
// Alignment
Css::alignment("#$id", $field['alignment']);
if( $field['enable_title_caption'] ){
  // Title
  Css::typography("#$id .qx-carousel-title", $field['title_font']);
  // Caption
  Css::typography("#$id .qx-carousel-caption", $field['caption_font']);
  
}
// Item
Css::margin("#$id .qx-carousel-item", $field['item_margin']);
Css::padding("#$id .qx-carousel-item", $field['item_padding']);
?>
#<?php echo $id?>{
  <?php Css::prop('background-color', $field['bg_color']);?>  
}

<?php if($field['enable_title_caption']):?>
  #<?php echo $id?> .qx-carousel-title{ <?php Css::prop('color', $field['title_color']);?> }
  #<?php echo $id?> .qx-carousel-caption{ <?php Css::prop('color', $field['caption_color']);?> }
<?php endif;?>

#<?php echo $id?> .qx-carousel-item{
  <?php Css::prop('background-color', $field['item_bg_color']);?>  
  transition: box-shadow 0.3s ease-in-out, transform 0.3s ease-in-out;
  <?php 
    // Box shadow
    if( $field['box_shadow'] ):?>
    box-shadow: <?php echo ($field['box_shadow_inset']) ? 'inset' : '' ?> <?php echo $field['box_shadow_horizontal']?>px <?php echo $field['box_shadow_vertical']?>px <?php echo $field['box_shadow_blur']?>px <?php echo $field['box_shadow_spread']?>px <?php echo $field['box_shadow_color']?>;
  <?php endif;?>  
}
<?php // Hover animation box shadow
  if( $field['hover_animation'] === 'shadow' ):?>
  #<?php echo $id?> .qx-carousel-item:hover{
    <?php Css::hoverBoxShadow($field); ?>
  }
<?php endif;?> 

#<?php echo $id ?> .slick-prev:before, 
#<?php echo $id ?> .slick-next:before{
  <?php Css::prop('color', $field['nav_color']); ?>
}
#<?php echo $id ?> .slick-dots li button:before {
    <?php Css::prop('color', $field['dots_nav_color']); ?>
}
#<?php echo $id ?> .slick-dots li.slick-active button:before {
    <?php Css::prop('color', $field['dots_nav_color']); ?>
}