<?php
/**
 * @version    3.6.8
 * @package    AMPZ
 * @author     roosterz.nl <roy@roosterz.nl>
 * @copyright  2020 roosterz.nl
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

// load the JS needed to handle the form data and send it back to the editor
$script = '
	jQuery(function($) {
		function insertAmpzShortcodeTag() {
			// Get field values
			shortcodename = $("#jform_shortcodename").val();
			tag = "{ampz:"+ shortcodename + "}";

			window.parent.jInsertEditorText(tag, ' . json_encode($this->eName) . ');
			window.parent.jModalClose();
			return false;
		}

		$(".ampzInsertShortcodeTag button").click(function() {
			insertAmpzShortcodeTag();
		})
	})
';

JFactory::getDocument()->addScriptDeclaration($script);

?>
<div class="ampzInsertShortcodeTag">
	<form>
		<?php echo $this->form->renderFieldset("main") ?>
		<button class="btn btn-primary span12">
			<?php echo JText::_('PLG_EDITORS-XTD_AMPZ_INSERTTAG'); ?>
		</button>
	</form>
</div>
