<?php
/**
 * Element: Articles
 * Displays a list of articles
 *
 * @package ampz
 * @copyright  2020 roosterz.nl
 * @ All rights reserved
 * @ Joomla! is Free Software
 * @ Released under GNU/GPL v3.0 License : http://www.gnu.org/licenses/gpl-3.0.html
 **/

defined('_JEXEC') or die;

class JFormFieldRH_Articles extends JFormField
{
	public $type = 'Articles';
	private $params = null;
	private $db = null;

	protected function getInput()
	{
		$this->params = $this->element->attributes();
		$this->db = JFactory::getDBO();

		$articles = $this->getArticles();

		if ($articles !== -1)
		{
			$options = array();

			foreach ($articles as $article)
			{
				$art_title_id = $article->title . " [" . $article->ctitle . "]" . " [" . $article->id . "]";
				$options[] = JHtml::_('select.option', $article->id, $art_title_id);
			}

			return JHtml::_('select.genericlist', $options, $this->name, array(
				'multiple' => 'multiple'
			), 'value', 'text', $this->value, $this->id);
		}
		else {
			return JText::sprintf("AMPZ_MORE_ARTICLES_THAN_MAX_LIST_COUNT", "Articles") ;
		}
	}

	function getArticles()
	{
		$query = $this->db->getQuery(true)
			->select('COUNT(*)')
			->from('#__content AS a')
			->where('a.access > -1');
		$this->db->setQuery($query);
		$total = $this->db->loadResult();

		$plugin = JPluginHelper::getPlugin('system', 'ampz');
		// Check if plugin is enabled
		if ($plugin)
		{
		    $pluginParams = new JRegistry($plugin->params);
		    $max_list_count = $pluginParams->get('max_list_count', 10000);
		}

		if ($total > $max_list_count)
		{
			return -1;
		}

		$query = $this->db->getQuery(true)
			->select('a.title, a.id, c.title as ctitle')
			->from('#__content AS a, #__categories AS c')
			->where('a.access > -1')
			->where('a.state > 0')
			->where('a.catid = c.id');
		$this->db->setQuery($query);
		$articles = $this->db->loadObjectList();

		return $articles;
	}

	private function get($val, $default = '')
	{
		return (isset($this->params[$val]) && (string) $this->params[$val] != '') ? (string) $this->params[$val] : $default;
	}
}
