--
-- Insert into Joomla core content type
--
INSERT IGNORE INTO `#__content_types` (`type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES
('Digicom Product', 'com_digicom.product', '{"special":{"dbtable":"#__digicom_products","key":"id","type":"product","prefix":"Table","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"introtext","core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access","core_params":"attribs","core_featured":"featured","core_metadata":"metadata","core_language":"language","core_images":"images","core_urls":"urls","core_version":"version","core_ordering":"ordering","core_metakey":"metakey","core_metadesc":"metadesc","core_catid":"catid","core_xreference":"xreference","asset_id":"asset_id"},"special":{"imptotal":"imptotal","impmade":"impmade","clicks":"clicks","clickurl":"clickurl","custombannercode":"custombannercode","cid":"cid","purchase_type":"purchase_type","track_impressions":"track_impressions","track_clicks":"track_clicks"}}', 'DigiComSiteHelperRoute::getProductRoute', '{"formFile":"administrator\\/components\\/com_digicom\\/models\\/forms\\/product.xml","hideFields":["checked_out","checked_out_time","version","reset"],"ignoreChanges":["modified_by","modified","checked_out","checked_out_time","version","imptotal","impmade","reset"],"convertToInt":["publish_up","publish_down","ordering"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
('Digicom Category', 'com_digicom.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"Table","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description","core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access","core_params":"params","core_featured":"null","core_metadata":"metadata","core_language":"language","core_images":"null","core_urls":"null","core_version":"version","core_ordering":"null","core_metakey":"metakey","core_metadesc":"metadesc","core_catid":"parent_id","core_xreference":"null","asset_id":"asset_id"},"special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'DigiComSiteHelperRoute::getCategoryRoute', '{"formFile":"administrator/components/com_digicom/models/forms/category.xml","hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"],"ignoreChanges":["modified_user_id","modified_time","checked_out","checked_out_time","version","hits","path"],"convertToInt":["publish_up","publish_down"],"displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}');

-- --------------------------------------------------------

--
-- Set primary settings for Extension
--

UPDATE `#__extensions` SET
`params`= '{"catalogue":"0","show_quantity":"0","show_validity":"1","time_format":"d-m-Y","hour24format":"0","ftp_source_path":"digicom","directfilelink":"0","askforbilling":"0","askforcompany":"1","topcountries":["Australia","Bangladesh","France","United-States"],"afteradditem":"2","default_payment":"offline","show_steps":"1","afterpurchase":"1","decimaldigits":"2","currency":"USD","currency_position":"1","usecimg":"0","thousands_group_symbol":",","store_name":"DigiCom Store","address":"","store_info":"","store_url":"DigiCom Store","phone":"","store_logo":"","template":"","category_cols":"3","image_thumb_enable":"1","image_thumb_width":"400","image_thumb_height":"250","image_thumb_method":"5","email_from_name":"DigiCom Store","email_from":"","email":{"new_order":{"subject":"[[SITENAME]] New customer order #[ORDER_ID] ","body":"<h2><strong>Congratulation! you just received an order. The order is as follows:<\\/strong><\\/h2>\\r\\n<p>Products<\\/p>\\r\\n<p><span style=\\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\\">----------------------------------<\\/span><\\/p>\\r\\n<p>[PRODUCTS]<\\/p>\\r\\n<p><span style=\\"font-size: 12.1599998474121px; line-height: 15.8079996109009px;\\">----------------------------------<\\/span><\\/p>\\r\\n<p><strong>Quantity<\\/strong> : [NUMBER_OF_PRODUCTS]<\\/p>\\r\\n<p><strong>Discount<\\/strong> : [DISCOUNT_AMOUNT]<\\/p>\\r\\n<p><strong>Total : [ORDER_AMOUNT]<\\/strong><\\/p>"},"process_order":{"subject":"Your [SITENAME] order receipt from [ORDER_DATE]","body":"<h1 style=\\"text-align: center;\\"><strong>Thank you for your order<\\/strong><\\/h1>\\r\\n<p style=\\"text-align: center;\\">Your order has been received and is now being processed. Your order details are shown below for your reference:<\\/p>\\r\\n<p><strong>Order Id<\\/strong> : [ORDER_ID]<\\/p>\\r\\n<p><strong>Products <\\/strong><\\/p>\\r\\n<p>----------------------------------<\\/p>\\r\\n<p>[PRODUCTS]<\\/p>\\r\\n<p>----------------------------------<\\/p>\\r\\n<p><strong>Quantity<\\/strong> : [NUMBER_OF_PRODUCTS]<\\/p>\\r\\n<p><strong>Order Status<\\/strong> : [ORDER_STATUS]<\\/p>\\r\\n<p><strong>Total : [ORDER_AMOUNT]<\\/strong><\\/p>"},"complete_order":{"subject":"Your [SITENAME] order from [ORDER_DATE] is complete","body":"<h1 style=\\"text-align: center;\\"><strong>Thank you for your order<\\/strong><\\/h1>\\r\\n<p style=\\"text-align: center;\\">Hi there. Your recent order on #[ORDER_ID] has been completed. Your order details are shown below for your reference:<\\/p>\\r\\n<p><strong>Order Id<\\/strong> : #[ORDER_ID]<\\/p>\\r\\n<p><strong>Products <\\/strong><\\/p>\\r\\n<p>----------------------------------<\\/p>\\r\\n<p>[PRODUCTS]<\\/p>\\r\\n<p>----------------------------------<\\/p>\\r\\n<p><strong>Quantity<\\/strong> : [NUMBER_OF_PRODUCTS]<\\/p>\\r\\n<p><strong>Total : [ORDER_AMOUNT]<\\/strong><\\/p>"},"cancel_order":{"subject":"[[SITENAME]] Cancel order #[ORDER_ID] ","body":"<h2><strong>Your Order has been cancelled!<\\/strong><\\/h2>"}}}'
WHERE `name`= 'com_digicom' and `type` = 'component' and `element` = 'com_digicom';

-- --------------------------------------------------------

--
-- Table structure for table `#__digicom_cart`
--

CREATE TABLE IF NOT EXISTS `#__digicom_cart` (
  `cid` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL DEFAULT '0',
  `quantity` int(11) NOT NULL DEFAULT '0',
  `sid` int(11) NOT NULL DEFAULT '0',
  `plugin_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cid`),
  KEY `productid` (`item_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__digicom_currencies`
--
--
-- DROP TABLE IF EXISTS `#__digicom_currencies`;
-- CREATE TABLE IF NOT EXISTS `#__digicom_currencies` (
--   `id` int(11) NOT NULL AUTO_INCREMENT,
--   `pluginid` varchar(30) NOT NULL DEFAULT '',
--   `currency_name` varchar(20) NOT NULL DEFAULT '',
--   `currency_full` varchar(50) NOT NULL DEFAULT '',
--   PRIMARY KEY (`id`)
-- ) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Dumping data for table `#__digicom_currencies`
--
--
-- INSERT INTO `#__digicom_currencies` (`id`, `pluginid`, `currency_name`, `currency_full`) VALUES
-- (1, '1', 'USD', 'U.S. Dollar'),
-- (2, '1', 'AUD', 'Australian Dollar'),
-- (3, '1', 'BDT', 'Taka'),
-- (4, '1', 'CAD', 'Canadian Dollar'),
-- (5, '1', 'CHF', 'Swiss Franc'),
-- (6, '1', 'CZK', 'Czech Koruna'),
-- (7, '1', 'DKK', 'Danish Krone'),
-- (8, '1', 'EUR', 'Euro'),
-- (9, '1', 'GBP', 'Pound Sterling'),
-- (10, '1', 'HKD', 'Hong Kong Dollar'),
-- (11, '1', 'HUF', 'Hungarian Forint'),
-- (12, '1', 'JPY', 'Japanese Yen'),
-- (13, '1', 'NOK', 'Norwegian Krone'),
-- (14, '1', 'NZD', 'New Zealand Dollar'),
-- (15, '1', 'PLN', 'Polish Zloty'),
-- (16, '1', 'SEK', 'Swedish Krona'),
-- (17, '1', 'SGD', 'Singapore Dollar'),
-- (18, '1', 'ILS', 'Israeli New Shekel (ILS)'),
-- (19, '1', 'MXN', 'Mexican Peso (MXN)'),
-- (20, '1', 'BRL', 'Brazilian Real (BRL)'),
-- (21, '1', 'MYR', 'Malaysian Ringgit (MYR)'),
-- (22, '1', 'PHP', 'Philippine Peso (PHP)'),
-- (23, '1', 'TWD', 'New Taiwan Dollar (TWD)'),
-- (24, '1', 'THB', 'Thai Baht (THB)'),
-- (25, '1', 'TRY', 'Turkish Lira (TRY)');

-- --------------------------------------------------------

--
-- Table structure for table `#__digicom_customers`
--

CREATE TABLE IF NOT EXISTS `#__digicom_customers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `email` varchar(250) NOT NULL,
  `address` varchar(200) NOT NULL DEFAULT '',
  `city` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `zipcode` varchar(20) NOT NULL DEFAULT '',
  `country` varchar(100) NOT NULL DEFAULT '',
  `phone` varchar(45) NOT NULL DEFAULT '',
  `payment_type` varchar(20) NOT NULL DEFAULT '',
  `company` varchar(100) NOT NULL DEFAULT '',
  `person` int(2) NOT NULL DEFAULT '0',
  `taxnum` varchar(255) DEFAULT '1',
  `taxclass` int(11) NOT NULL DEFAULT '0',
  `registered` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=315 ;

-- --------------------------------------------------------

--
-- Table structure for table `#__digicom_licenses`
--

CREATE TABLE IF NOT EXISTS `#__digicom_licenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `licenseid` int(11) NOT NULL,
  `orderid` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `productid` int(11) NOT NULL,
  `purchase` datetime NOT NULL,
  `expires` datetime NOT NULL,
  `active` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `userid` (`userid`),
  KEY `productid` (`productid`),
  KEY `orderid` (`orderid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=42 ;

-- --------------------------------------------------------

--
-- Table structure for table `#__digicom_log`
--

CREATE TABLE IF NOT EXISTS `#__digicom_log` (
  `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL,
  `type` varchar(255) NOT NULL COMMENT 'download|email|purchase|status|payment',
  `callback` varchar(255) NOT NULL COMMENT 'who trigger the event',
  `callbackid` INT NULL DEFAULT NULL COMMENT  'orderid | fileid ; quickid to find items',
  `refid` VARCHAR(50) NOT NULL COMMENT 'if ref numbar provided',
  `message` varchar(255) NOT NULL COMMENT 'small message',
  `status` varchar(255) NOT NULL DEFAULT 'complete' COMMENT 'event status:complete',
  `ip` varchar(255) NOT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `params` longtext NOT NULL COMMENT 'details info about event',
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__digicom_orders`
--

CREATE TABLE IF NOT EXISTS `#__digicom_orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL DEFAULT '0',
  `transaction_number` varchar(250) NOT NULL,
  `order_date` DATETIME NOT NULL,
  `price` DECIMAL( 13, 3 ) NOT NULL DEFAULT '0' COMMENT 'original price without discount and tax',
  `amount` DECIMAL( 13, 3 ) NOT NULL DEFAULT '0' COMMENT 'payable amount',
  `tax` DECIMAL( 13, 3 ) NOT NULL DEFAULT '0',
  `discount` DECIMAL( 13, 3 ) NOT NULL DEFAULT '0',
  `amount_paid` DECIMAL( 13, 3 ) NOT NULL DEFAULT '0',
  `number_of_products` int(11) NOT NULL DEFAULT '0',
  `currency` varchar(10) NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT '',
  `promocodeid` int(11) NOT NULL DEFAULT '0',
  `promocode` varchar(255) NOT NULL DEFAULT '',
  `processor` varchar(100) NOT NULL,
  `published` int(11) NOT NULL DEFAULT '0',
  `chargeback` tinyint(1) NOT NULL DEFAULT '0',
  `comment` longtext NOT NULL,
  `update_date` TIMESTAMP ON UPDATE CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=500 ;

-- --------------------------------------------------------

--
-- Table structure for table `#__digicom_orders_details`
--

CREATE TABLE IF NOT EXISTS `#__digicom_orders_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL DEFAULT '0',
  `productid` int(11) NOT NULL DEFAULT '0',
  `quantity` int(11) NOT NULL,
  `price` DECIMAL( 13,3 ) NOT NULL ,
  `amount_paid` DECIMAL( 13,3 ) NOT NULL,
  `orderid` int(11) NOT NULL DEFAULT '0',
  `published` int(2) NOT NULL DEFAULT '1',
  `package_type` varchar(50) NOT NULL,
  `purchase_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `update` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cancelled` tinyint(1) NOT NULL DEFAULT '0',
  `cancelled_amount` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `orderid` (`orderid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ;

-- --------------------------------------------------------

--
-- Table structure for table `#__digicom_products`
--

CREATE TABLE IF NOT EXISTS `#__digicom_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) NOT NULL COMMENT 'FK to the #__assets table.',
  `catid` int(11) NOT NULL,
  `product_type` varchar(50) NOT NULL DEFAULT 'reguler' COMMENT 'reguler,bundle',
  `name` varchar(150) NOT NULL DEFAULT '',
  `alias` varchar(150) NOT NULL,
  `introtext` mediumtext NOT NULL,
  `fulltext` longtext NOT NULL COMMENT 'full desc',
  `images` varchar(255) NOT NULL DEFAULT '', 
  `price` DECIMAL( 12, 2 ) NOT NULL ,
  `price_type` tinyint(4) NOT NULL DEFAULT '3',
  `expiration_length` tinyint(4) NOT NULL,
  `expiration_type` varchar(15) NOT NULL,
  `bundle_source` varchar(50) DEFAULT NULL,
  `language` char(7) NOT NULL DEFAULT '*',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `featured` int(11) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `publish_up` DATETIME NOT NULL DEFAULT  '0000-00-00 00:00:00',
  `publish_down` DATETIME NOT NULL DEFAULT  '0000-00-00 00:00:00',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `published` int(11) NOT NULL DEFAULT '0',
  `metatitle` varchar(100) NOT NULL DEFAULT '',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `hide_public` tinyint(1) NOT NULL DEFAULT '0',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `urls` text NOT NULL,
  `used` int(11) NOT NULL DEFAULT '0',
  `hits` int(11) NOT NULL,
  `attribs` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ;

-- --------------------------------------------------------

--
-- Table structure for table `#__digicom_products_bundle`
--

CREATE TABLE IF NOT EXISTS `#__digicom_products_bundle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `bundle_id` int(11) NOT NULL,
  `bundle_type` varchar(50) NOT NULL DEFAULT 'product',
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

-- --------------------------------------------------------

--
-- Table structure for table `#__digicom_products_files`
--

CREATE TABLE IF NOT EXISTS `#__digicom_products_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `name` varchar(250) NOT NULL,
  `url` varchar(250) NOT NULL,
  `creation_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `hits` int(11) NOT NULL,
  `ordering` varchar(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

-- --------------------------------------------------------

--
-- Table structure for table `#__digicom_products_rating`
--

CREATE TABLE IF NOT EXISTS `#__digicom_products_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',
  `rating_count` int(10) unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__digicom_promocodes`
--

CREATE TABLE IF NOT EXISTS `#__digicom_promocodes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL DEFAULT '',
  `code` varchar(100) NOT NULL DEFAULT '',
  `codelimit` int(11) NOT NULL DEFAULT '0',
  `amount` float NOT NULL DEFAULT '0',
  `codestart` DATETIME NOT NULL DEFAULT  '0000-00-00 00:00:00',
  `codeend` DATETIME NOT NULL DEFAULT  '0000-00-00 00:00:00',
  `forexisting` int(11) NOT NULL DEFAULT '0',
  `published` int(11) NOT NULL DEFAULT '0',
  `aftertax` int(11) NOT NULL DEFAULT '0',
  `promotype` int(11) NOT NULL DEFAULT '1',
  `discount_enable_range` tinyint(4) NOT NULL,
  `used` int(11) NOT NULL DEFAULT '0',
  `validfornew` int(11) NOT NULL DEFAULT '0',
  `validforrenewal` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `#__digicom_promocodes_products`
--

CREATE TABLE IF NOT EXISTS `#__digicom_promocodes_products` (
  `productid` int(11) NOT NULL,
  `promoid` int(11) NOT NULL,
  KEY `productid` (`productid`,`promoid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__digicom_session`
--
CREATE TABLE IF NOT EXISTS `#__digicom_session` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sid` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `uid` int(11) NOT NULL,
  `create_time` datetime NOT NULL,
  `cart_details` text NOT NULL,
  `transaction_details` text NOT NULL,
  `shipping_details` varchar(255) NOT NULL,
  `processor` varchar(250) NOT NULL,
  `key` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ;
-- --------------------------------------------------------

--
-- Table structure for table `#__digicom_states`
--

CREATE TABLE IF NOT EXISTS `#__digicom_states` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `state` varchar(200) NOT NULL DEFAULT '',
  `country` varchar(200) NOT NULL DEFAULT '',
  `eumember` int(2) NOT NULL DEFAULT '0',
  `ccode` varchar(5) NOT NULL DEFAULT '',
  `scode` varchar(5) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=730 ;

--
-- Dumping data for table `#__digicom_states`
--

INSERT IGNORE INTO `#__digicom_states` (`id`, `state`, `country`, `eumember`, `ccode`, `scode`) VALUES
(1, 'Afghanistan', 'Afghanistan', 0, 'AF', ''),
(2, 'Algeria', 'Algeria', 0, 'DZ', ''),
(3, 'American-Samoa', 'American-Samoa', 0, 'AS', ''),
(4, 'Andorra', 'Andorra', 0, 'AD', ''),
(5, 'Angola', 'Angola', 0, 'AO', ''),
(6, 'Anguilla', 'Anguilla', 0, 'AI', ''),
(7, 'Antigua-and-Barbuda', 'Antigua-and-Barbuda', 0, 'AG', ''),
(8, 'Argentina', 'Argentina', 0, 'AR', ''),
(9, 'Armenia', 'Armenia', 0, 'AM', ''),
(10, 'Ascension-Island', 'Ascension-Island', 0, 'AC', ''),
(11, 'Australian Capital Territory', 'Australia', 0, 'AU', ''),
(12, 'Christmas Island', 'Australia', 0, 'AU', ''),
(13, 'New South Wales', 'Australia', 0, 'AU', ''),
(14, 'Northern Territory', 'Australia', 0, 'AU', ''),
(15, 'Queensland', 'Australia', 0, 'AU', ''),
(16, 'South Australia', 'Australia', 0, 'AU', ''),
(17, 'Tasmania', 'Australia', 0, 'AU', ''),
(18, 'Victoria', 'Australia', 0, 'AU', ''),
(19, 'Western Australia', 'Australia', 0, 'AU', ''),
(20, 'Austria', 'Austria', 1, 'AT', ''),
(21, 'Azerbaijan', 'Azerbaijan', 0, 'AZ', ''),
(22, 'Bahamas', 'Bahamas', 0, 'BS', ''),
(23, 'Bahrain', 'Bahrain', 0, 'BH', ''),
(24, 'Bangladesh', 'Bangladesh', 0, 'BD', ''),
(25, 'Barbados', 'Barbados', 0, 'BB', ''),
(26, 'Belarus', 'Belarus', 0, 'BY', ''),
(27, 'Belgium', 'Belgium', 1, 'BE', ''),
(28, 'Belize', 'Belize', 0, 'BZ', ''),
(29, 'Benin', 'Benin', 0, 'BJ', ''),
(30, 'Bermuda', 'Bermuda', 0, 'BM', ''),
(31, 'Bhutan', 'Bhutan', 0, 'BT', ''),
(32, 'Bolivia', 'Bolivia', 0, 'BO', ''),
(33, 'Bosnia-and-Herzegovina', 'Bosnia-and-Herzegovina', 0, 'BA', ''),
(34, 'Botswana', 'Botswana', 0, 'BW', ''),
(35, 'Brazil', 'Brazil', 0, 'BR', ''),
(36, 'Sergipe', 'Brazil', 0, 'BR', ''),
(37, 'British-Indian-Ocean-Territory', 'British-Indian-Ocean-Territory', 0, 'IO', ''),
(38, 'Brunei-Darussalam', 'Brunei-Darussalam', 0, 'BN', ''),
(39, 'Bulgaria', 'Bulgaria', 1, 'BG', ''),
(40, 'Burkina-Faso', 'Burkina-Faso', 0, 'BF', ''),
(41, 'Burundi', 'Burundi', 0, 'BI', ''),
(42, 'Camaroon', 'Camaroon', 0, 'CM', ''),
(43, 'Cambodia', 'Cambodia', 0, 'KH', ''),
(44, 'Cameroon', 'Cameroon', 0, 'CM', ''),
(45, 'Alberta', 'Canada', 0, 'CA', ''),
(46, 'British Columbia', 'Canada', 0, 'CA', ''),
(47, 'Manitoba', 'Canada', 0, 'CA', ''),
(48, 'New Brunswick', 'Canada', 0, 'CA', ''),
(49, 'Newfoundland', 'Canada', 0, 'CA', ''),
(50, 'Northwest Territories', 'Canada', 0, 'CA', ''),
(51, 'Nova Scotia', 'Canada', 0, 'CA', ''),
(52, 'Nunavut', 'Canada', 0, 'CA', ''),
(53, 'Ontario', 'Canada', 0, 'CA', ''),
(54, 'Prince Edward Island', 'Canada', 0, 'CA', ''),
(55, 'Quebec', 'Canada', 0, 'CA', ''),
(56, 'Saskatchewan', 'Canada', 0, 'CA', ''),
(57, 'Yukon', 'Canada', 0, 'CA', ''),
(58, 'Cape-Verde', 'Cape-Verde', 0, 'CV', ''),
(59, 'Cayman-Islands', 'Cayman-Islands', 0, 'KY', ''),
(60, 'Central-African-Republic', 'Central-African-Republic', 0, 'CF', ''),
(61, 'Chad', 'Chad', 0, 'TD', ''),
(62, 'Chile', 'Chile', 0, 'CL', ''),
(63, 'Anhui', 'China', 0, 'CN', ''),
(64, 'Beijing', 'China', 0, 'CN', ''),
(65, 'China', 'China', 0, 'CN', ''),
(66, 'Fujian', 'China', 0, 'CN', ''),
(67, 'Gansu', 'China', 0, 'CN', ''),
(68, 'Guangdong', 'China', 0, 'CN', ''),
(69, 'Guangxi', 'China', 0, 'CN', ''),
(70, 'Guizhou', 'China', 0, 'CN', ''),
(71, 'Hebei', 'China', 0, 'CN', ''),
(72, 'Heilongjiang', 'China', 0, 'CN', ''),
(73, 'Henan', 'China', 0, 'CN', ''),
(74, 'Hong-Kong', 'China', 0, 'CN', ''),
(75, 'Hubei', 'China', 0, 'CN', ''),
(76, 'Hunan', 'China', 0, 'CN', ''),
(77, 'Jiangsu', 'China', 0, 'CN', ''),
(78, 'Jiangxi', 'China', 0, 'CN', ''),
(79, 'Jilin', 'China', 0, 'CN', ''),
(80, 'Liaoning', 'China', 0, 'CN', ''),
(81, 'Macau', 'China', 0, 'CN', ''),
(82, 'Nei Mongol', 'China', 0, 'CN', ''),
(83, 'Ningxia', 'China', 0, 'CN', ''),
(84, 'Quinghai', 'China', 0, 'CN', ''),
(85, 'Shaanxi', 'China', 0, 'CN', ''),
(86, 'Shandong', 'China', 0, 'CN', ''),
(87, 'Shanghai', 'China', 0, 'CN', ''),
(88, 'Shanxi', 'China', 0, 'CN', ''),
(89, 'Sichuan', 'China', 0, 'CN', ''),
(90, 'Taiwan', 'China', 0, 'CN', ''),
(91, 'Tianjin', 'China', 0, 'CN', ''),
(92, 'Xinjiang', 'China', 0, 'CN', ''),
(93, 'Xizang', 'China', 0, 'CN', ''),
(94, 'Yunnan', 'China', 0, 'CN', ''),
(95, 'Zhejiang', 'China', 0, 'CN', ''),
(96, 'Colombia', 'Colombia', 0, 'CO', ''),
(97, 'Comoros', 'Comoros', 0, 'KM', ''),
(98, 'Congo', 'Congo', 0, 'CG', ''),
(99, 'Aitutaki', 'Cook-Islands', 0, 'CK', ''),
(100, 'Atiu', 'Cook-Islands', 0, 'CK', ''),
(101, 'Mangaia', 'Cook-Islands', 0, 'CK', ''),
(102, 'Manuae', 'Cook-Islands', 0, 'CK', ''),
(103, 'Mauke', 'Cook-Islands', 0, 'CK', ''),
(104, 'Mitiaro', 'Cook-Islands', 0, 'CK', ''),
(105, 'Palmerston', 'Cook-Islands', 0, 'CK', ''),
(106, 'Rarotonga', 'Cook-Islands', 0, 'CK', ''),
(107, 'Suwarrow', 'Cook-Islands', 0, 'CK', ''),
(108, 'Tatutea', 'Cook-Islands', 0, 'CK', ''),
(109, 'Costa-Rica', 'Costa-Rica', 0, 'CR', ''),
(110, 'Cote-D-Ivoire', 'Cote-D-Ivoire', 0, 'CI', ''),
(111, 'Croatia', 'Croatia', 0, 'HR', ''),
(112, 'Cuba', 'Cuba', 0, 'CU', ''),
(113, 'Cyprus', 'Cyprus', 1, 'CY', ''),
(114, 'Czech-Republic', 'Czech-Republic', 1, 'CZ', ''),
(115, 'Denmark', 'Denmark', 1, 'DK', ''),
(116, 'Djibouti', 'Djibouti', 0, 'DJ', ''),
(117, 'Dominica', 'Dominica', 0, 'DM', ''),
(118, 'Dominican-Republic', 'Dominican-Republic', 0, 'DO', ''),
(119, 'Ecuador', 'Ecuador', 0, 'EC', ''),
(120, 'Egypt', 'Egypt', 0, 'EG', ''),
(121, 'El-Salvador', 'El-Salvador', 0, 'SV', ''),
(122, 'Equatorial-Guinea', 'Equatorial-Guinea', 0, 'GQ', ''),
(123, 'Eritrea', 'Eritrea', 0, 'ER', ''),
(124, 'Estonia', 'Estonia', 1, 'EE', ''),
(125, 'Ethiopia', 'Ethiopia', 0, 'ET', ''),
(126, 'Falkland-Islands', 'Falkland-Islands', 0, 'FK', ''),
(127, 'Faroe-Islands', 'Faroe-Islands', 0, 'FO', ''),
(128, 'Federated-States-of-Micronesia', 'Federated-States-of-Micronesia', 0, 'FM', ''),
(129, 'Kandavu', 'Fiji', 0, 'FJ', ''),
(130, 'Lau Group', 'Fiji', 0, 'FJ', ''),
(131, 'Ono-I-Lau', 'Fiji', 0, 'FJ', ''),
(132, 'Rotuma', 'Fiji', 0, 'FJ', ''),
(133, 'Taveuni', 'Fiji', 0, 'FJ', ''),
(134, 'Vanua Levu', 'Fiji', 0, 'FJ', ''),
(135, 'Vanua Mbalavu', 'Fiji', 0, 'FJ', ''),
(136, 'Vita Levu', 'Fiji', 0, 'FJ', ''),
(137, 'Finland', 'Finland', 1, 'FI', ''),
(138, 'Hame', 'Finland', 1, 'FI', ''),
(139, 'France', 'France', 1, 'FR', ''),
(140, 'French-Guiana', 'French-Guiana', 0, 'GF', ''),
(141, 'Ahunui Island', 'French-Polynesia', 0, 'PF', ''),
(142, 'Amanu Island', 'French-Polynesia', 0, 'PF', ''),
(143, 'Anaa Island', 'French-Polynesia', 0, 'PF', ''),
(144, 'Bellingshausen Island', 'French-Polynesia', 0, 'PF', ''),
(145, 'Bora-Bora Island', 'French-Polynesia', 0, 'PF', ''),
(146, 'Fakarava Island', 'French-Polynesia', 0, 'PF', ''),
(147, 'Hao Island', 'French-Polynesia', 0, 'PF', ''),
(148, 'Haraiki Island', 'French-Polynesia', 0, 'PF', ''),
(149, 'Hikueru Island', 'French-Polynesia', 0, 'PF', ''),
(150, 'Hiva Oa Island', 'French-Polynesia', 0, 'PF', ''),
(151, 'Kaukura Island', 'French-Polynesia', 0, 'PF', ''),
(152, 'Makatea Island', 'French-Polynesia', 0, 'PF', ''),
(153, 'Makemo Island', 'French-Polynesia', 0, 'PF', ''),
(154, 'Manuhangi Island', 'French-Polynesia', 0, 'PF', ''),
(155, 'Maria Island', 'French-Polynesia', 0, 'PF', ''),
(156, 'Marutea Island', 'French-Polynesia', 0, 'PF', ''),
(157, 'Mataiva Island', 'French-Polynesia', 0, 'PF', ''),
(158, 'Mehetia Island', 'French-Polynesia', 0, 'PF', ''),
(159, 'Moorea Island', 'French-Polynesia', 0, 'PF', ''),
(160, 'Mopelia Island', 'French-Polynesia', 0, 'PF', ''),
(161, 'Nengonengo Island', 'French-Polynesia', 0, 'PF', ''),
(162, 'Raevavae Island', 'French-Polynesia', 0, 'PF', ''),
(163, 'Raiatea Island', 'French-Polynesia', 0, 'PF', ''),
(164, 'Rapa Island', 'French-Polynesia', 0, 'PF', ''),
(165, 'Raraka Island', 'French-Polynesia', 0, 'PF', ''),
(166, 'Raroia Island', 'French-Polynesia', 0, 'PF', ''),
(167, 'Ravahere Island', 'French-Polynesia', 0, 'PF', ''),
(168, 'Rimatara Island', 'French-Polynesia', 0, 'PF', ''),
(169, 'Rurutu Island', 'French-Polynesia', 0, 'PF', ''),
(170, 'Scilly Island', 'French-Polynesia', 0, 'PF', ''),
(171, 'Tahaa Island', 'French-Polynesia', 0, 'PF', ''),
(172, 'Tahiti Island', 'French-Polynesia', 0, 'PF', ''),
(173, 'Tahuata Island', 'French-Polynesia', 0, 'PF', ''),
(174, 'Takapoto Island', 'French-Polynesia', 0, 'PF', ''),
(175, 'Tematangi Island', 'French-Polynesia', 0, 'PF', ''),
(176, 'Tetiaroa Island', 'French-Polynesia', 0, 'PF', ''),
(177, 'Tikei Island', 'French-Polynesia', 0, 'PF', ''),
(178, 'Vanavana Island', 'French-Polynesia', 0, 'PF', ''),
(179, 'Gabon', 'Gabon', 0, 'GA', ''),
(180, 'Georgia', 'Georgia', 0, 'GE', ''),
(181, 'Bayern', 'Germany', 1, 'DE', ''),
(182, 'Brandenburg', 'Germany', 1, 'DE', ''),
(183, 'Bremen', 'Germany', 1, 'DE', ''),
(184, 'Germany', 'Germany', 1, 'DE', ''),
(185, 'Nordrhein-Westfalen', 'Germany', 1, 'DE', ''),
(186, 'Rheinland-Pfalz', 'Germany', 1, 'DE', ''),
(187, 'Sachsen', 'Germany', 1, 'DE', ''),
(188, 'Sachsen-Anhalt', 'Germany', 1, 'DE', ''),
(189, 'Thuringen', 'Germany', 1, 'DE', ''),
(190, 'Ghana', 'Ghana', 0, 'GH', ''),
(191, 'Gibralter', 'Gibralter', 0, 'GI', ''),
(192, 'Greece', 'Greece', 1, 'GR', ''),
(193, 'Greenland', 'Greenland', 0, 'GL', ''),
(194, 'Grenada', 'Grenada', 0, 'GD', ''),
(195, 'Guadeloupe', 'Guadeloupe', 0, 'GP', ''),
(196, 'Guam', 'Guam', 0, 'GU', ''),
(197, 'Guatemala', 'Guatemala', 0, 'GT', ''),
(198, 'Guinea', 'Guinea', 0, 'GN', ''),
(199, 'Guinea-Bissau', 'Guinea-Bissau', 0, 'GW', ''),
(200, 'Guyana', 'Guyana', 0, 'GY', ''),
(201, 'Haiti', 'Haiti', 0, 'HT', ''),
(202, 'Honduras', 'Honduras', 0, 'HN', ''),
(203, 'Hong-Kong', 'Hong-Kong', 0, 'HK', ''),
(204, 'Hungary', 'Hungary', 1, 'HU', ''),
(205, 'Iceland', 'Iceland', 0, 'IS', ''),
(206, 'Bass', 'Ilots', 0, '', ''),
(207, 'de Gdansk (Danzig)', 'Ind. before 1939', 0, '', ''),
(208, 'Andhra Pradesh', 'India', 0, 'IN', ''),
(209, 'Delhi', 'India', 0, 'IN', ''),
(210, 'Gujarat', 'India', 0, 'IN', ''),
(211, 'Haryana', 'India', 0, 'IN', ''),
(212, 'India', 'India', 0, 'IN', ''),
(213, 'Karnataka', 'India', 0, 'IN', ''),
(214, 'Kerala', 'India', 0, 'IN', ''),
(215, 'Madhya Pradesh', 'India', 0, 'IN', ''),
(216, 'Maharashtra', 'India', 0, 'IN', ''),
(217, 'Orissa', 'India', 0, 'IN', ''),
(218, 'Punjab', 'India', 0, 'IN', ''),
(219, 'Rajastan', 'India', 0, 'IN', ''),
(220, 'Tamil Nadu', 'India', 0, 'IN', ''),
(221, 'Uttar Pradesh', 'India', 0, 'IN', ''),
(222, 'West Bengal', 'India', 0, 'IN', ''),
(223, 'Bali', 'Indonesia', 0, 'ID', ''),
(224, 'Bangka', 'Indonesia', 0, 'ID', ''),
(225, 'Belitung', 'Indonesia', 0, 'ID', ''),
(226, 'Borneo (Kalimantan)', 'Indonesia', 0, 'ID', ''),
(227, 'Buru', 'Indonesia', 0, 'ID', ''),
(228, 'Flores', 'Indonesia', 0, 'ID', ''),
(229, 'Halmahera', 'Indonesia', 0, 'ID', ''),
(230, 'Indonesia', 'Indonesia', 0, 'ID', ''),
(231, 'Jawa (Java)', 'Indonesia', 0, 'ID', ''),
(232, 'Kabaena', 'Indonesia', 0, 'ID', ''),
(233, 'Kepulauan Alor (Pulau Alor)', 'Indonesia', 0, 'ID', ''),
(234, 'Kepulauan Anambas', 'Indonesia', 0, 'ID', ''),
(235, 'Kepulauan Aru', 'Indonesia', 0, 'ID', ''),
(236, 'Kepulauan Banda', 'Indonesia', 0, 'ID', ''),
(237, 'Kepulauan Banggai', 'Indonesia', 0, 'ID', ''),
(238, 'Kepulauan Batu', 'Indonesia', 0, 'ID', ''),
(239, 'Kepulauan Bowokan', 'Indonesia', 0, 'ID', ''),
(240, 'Kepulauan Bunguran Selatan', 'Indonesia', 0, 'ID', ''),
(241, 'Kepulauan Bunguran Utara', 'Indonesia', 0, 'ID', ''),
(242, 'Kepulauan Kai', 'Indonesia', 0, 'ID', ''),
(243, 'Kepulauan Kangean', 'Indonesia', 0, 'ID', ''),
(244, 'Kepulauan Leti', 'Indonesia', 0, 'ID', ''),
(245, 'Kepulauan Lingga', 'Indonesia', 0, 'ID', ''),
(246, 'Kepulauan Mentawai', 'Indonesia', 0, 'ID', ''),
(247, 'Kepulauan Sangihe', 'Indonesia', 0, 'ID', ''),
(248, 'Kepulauan Schouten', 'Indonesia', 0, 'ID', ''),
(249, 'Kepulauan Tanimbar', 'Indonesia', 0, 'ID', ''),
(250, 'Kepulauan Togian', 'Indonesia', 0, 'ID', ''),
(251, 'Kepulauan Tukangbesi', 'Indonesia', 0, 'ID', ''),
(252, 'Lombok', 'Indonesia', 0, 'ID', ''),
(253, 'Madura', 'Indonesia', 0, 'ID', ''),
(254, 'Maluku', 'Indonesia', 0, 'ID', ''),
(255, 'Muna', 'Indonesia', 0, 'ID', ''),
(256, 'New Guinea (Irian Jaya)', 'Indonesia', 0, 'ID', ''),
(257, 'Pulau Babar', 'Indonesia', 0, 'ID', ''),
(258, 'Pulau Bacan', 'Indonesia', 0, 'ID', ''),
(259, 'Pulau Bawean', 'Indonesia', 0, 'ID', ''),
(260, 'Pulau Bengkalis', 'Indonesia', 0, 'ID', ''),
(261, 'Pulau Bintan', 'Indonesia', 0, 'ID', ''),
(262, 'Pulau Butung', 'Indonesia', 0, 'ID', ''),
(263, 'Pulau Damar', 'Indonesia', 0, 'ID', ''),
(264, 'Pulau Enggano', 'Indonesia', 0, 'ID', ''),
(265, 'Pulau Kalao', 'Indonesia', 0, 'ID', ''),
(266, 'Pulau Kundur', 'Indonesia', 0, 'ID', ''),
(267, 'Pulau Laut', 'Indonesia', 0, 'ID', ''),
(268, 'Pulau Lomblen', 'Indonesia', 0, 'ID', ''),
(269, 'Pulau Misool', 'Indonesia', 0, 'ID', ''),
(270, 'Pulau Nias', 'Indonesia', 0, 'ID', ''),
(271, 'Pulau Obi', 'Indonesia', 0, 'ID', ''),
(272, 'Pulau Padang', 'Indonesia', 0, 'ID', ''),
(273, 'Pulau Pantar', 'Indonesia', 0, 'ID', ''),
(274, 'Pulau Rangsang', 'Indonesia', 0, 'ID', ''),
(275, 'Pulau Rupat', 'Indonesia', 0, 'ID', ''),
(276, 'Pulau Sebangka', 'Indonesia', 0, 'ID', ''),
(277, 'Pulau Seleyar (Salayar)', 'Indonesia', 0, 'ID', ''),
(278, 'Pulau Siberut', 'Indonesia', 0, 'ID', ''),
(279, 'Pulau Simeulue', 'Indonesia', 0, 'ID', ''),
(280, 'Pulau Singkep', 'Indonesia', 0, 'ID', ''),
(281, 'Pulau Tanahjampea', 'Indonesia', 0, 'ID', ''),
(282, 'Pulau Tebingtinggi', 'Indonesia', 0, 'ID', ''),
(283, 'Pulau Waigeo', 'Indonesia', 0, 'ID', ''),
(284, 'Pulau Wowoni', 'Indonesia', 0, 'ID', ''),
(285, 'Pulau Yapen', 'Indonesia', 0, 'ID', ''),
(286, 'Salawati', 'Indonesia', 0, 'ID', ''),
(287, 'Seram (Ceram)', 'Indonesia', 0, 'ID', ''),
(288, 'Sulawesi (Celebes)', 'Indonesia', 0, 'ID', ''),
(289, 'Sumatera (Sumatra)', 'Indonesia', 0, 'ID', ''),
(290, 'Sumba', 'Indonesia', 0, 'ID', ''),
(291, 'Sumbawa', 'Indonesia', 0, 'ID', ''),
(292, 'Timor (Timur)', 'Indonesia', 0, 'ID', ''),
(293, 'Iran', 'Iran', 0, 'IR', ''),
(294, 'Iraq', 'Iraq', 0, 'IQ', ''),
(295, 'Ireland', 'Ireland', 1, 'IE', ''),
(296, 'Isle-of-Man', 'Isle-of-Man', 0, 'IM', ''),
(297, 'Golan Heights', 'Israel', 0, 'IL', ''),
(298, 'Israel', 'Israel', 0, 'IL', ''),
(299, 'Italy', 'Italy', 1, 'IT', ''),
(300, 'Jamaica', 'Jamaica', 0, 'JM', ''),
(301, 'Japan', 'Japan', 0, 'JP', ''),
(302, 'Mie', 'Japan', 0, 'JP', ''),
(303, 'Shizuoka', 'Japan', 0, 'JP', ''),
(304, 'Toyama', 'Japan', 0, 'JP', ''),
(305, 'Jordan', 'Jordan', 0, 'JO', ''),
(306, 'Kazakhstan', 'Kazakhstan', 0, 'KZ', ''),
(307, 'Kenya', 'Kenya', 0, 'KE', ''),
(308, 'Abemama Island', 'Kiribati', 0, 'KI', ''),
(309, 'Arorae Island', 'Kiribati', 0, 'KI', ''),
(310, 'Banaba Island', 'Kiribati', 0, 'KI', ''),
(311, 'Beru Island', 'Kiribati', 0, 'KI', ''),
(312, 'Birnie Island', 'Kiribati', 0, 'KI', ''),
(313, 'Canton Island', 'Kiribati', 0, 'KI', ''),
(314, 'Caroline Atoll', 'Kiribati', 0, 'KI', ''),
(315, 'Christmas Island', 'Kiribati', 0, 'KI', ''),
(316, 'Enderbury Island', 'Kiribati', 0, 'KI', ''),
(317, 'Fanning Island', 'Kiribati', 0, 'KI', ''),
(318, 'Filippo Reef', 'Kiribati', 0, 'KI', ''),
(319, 'Flint Island', 'Kiribati', 0, 'KI', ''),
(320, 'Gardner Island', 'Kiribati', 0, 'KI', ''),
(321, 'Hull Island', 'Kiribati', 0, 'KI', ''),
(322, 'Kiritimati(Christmas) Is', 'Kiribati', 0, 'KI', ''),
(323, 'Kuria Island', 'Kiribati', 0, 'KI', ''),
(324, 'Makin Island', 'Kiribati', 0, 'KI', ''),
(325, 'Malden Island', 'Kiribati', 0, 'KI', ''),
(326, 'Merlin Seamount', 'Kiribati', 0, 'KI', ''),
(327, 'Nikunau Island', 'Kiribati', 0, 'KI', ''),
(328, 'Nonouti Island', 'Kiribati', 0, 'KI', ''),
(329, 'Onotoa Island', 'Kiribati', 0, 'KI', ''),
(330, 'Phoenix Island', 'Kiribati', 0, 'KI', ''),
(331, 'Starbuck Island', 'Kiribati', 0, 'KI', ''),
(332, 'Sydney Island', 'Kiribati', 0, 'KI', ''),
(333, 'Tabiteuea Island', 'Kiribati', 0, 'KI', ''),
(334, 'Tamana Island', 'Kiribati', 0, 'KI', ''),
(335, 'Tapeteuea Island', 'Kiribati', 0, 'KI', ''),
(336, 'Tarawa Island', 'Kiribati', 0, 'KI', ''),
(337, 'Vostok Island', 'Kiribati', 0, 'KI', ''),
(338, 'Washington Island', 'Kiribati', 0, 'KI', ''),
(339, 'Korea-(Peoples-Republic-of)', 'Korea-(Peoples-Republic-of)', 0, 'KP', ''),
(340, 'Korea-(Republic-of)', 'Korea-(Republic-of)', 0, 'KR', ''),
(341, 'Kuwait', 'Kuwait', 0, 'KW', ''),
(342, 'Kyrgyzstan', 'Kyrgyzstan', 0, 'KG', ''),
(343, 'Laos', 'Laos', 0, 'LA', ''),
(344, 'Latvia', 'Latvia', 1, 'LV', ''),
(345, 'Lebanon', 'Lebanon', 0, 'LB', ''),
(346, 'Lesotho', 'Lesotho', 0, 'LS', ''),
(347, 'Liberia', 'Liberia', 0, 'LR', ''),
(348, 'Libya', 'Libya', 0, 'LY', ''),
(349, 'Liechtenstein', 'Liechtenstein', 0, 'LI', ''),
(350, 'Lithuania', 'Lithuania', 1, 'LT', ''),
(351, 'Luxembourg', 'Luxembourg', 1, 'LU', ''),
(352, 'Macau', 'Macau', 0, 'MO', ''),
(353, 'Macedonia', 'Macedonia', 0, 'MK', ''),
(354, 'Madagascar', 'Madagascar', 0, 'MG', ''),
(355, 'Malawi', 'Malawi', 0, 'MW', ''),
(356, 'Labuan', 'Malaysia', 0, 'MY', ''),
(357, 'Malaya', 'Malaysia', 0, 'MY', ''),
(358, 'Malaysia', 'Malaysia', 0, 'MY', ''),
(359, 'Sarawak', 'Malaysia', 0, 'MY', ''),
(360, 'Maldives', 'Maldives', 0, 'MV', ''),
(361, 'Mali', 'Mali', 0, 'ML', ''),
(362, 'Malta', 'Malta', 1, 'MT', ''),
(363, 'Marshall-Islands', 'Marshall-Islands', 0, 'MH', ''),
(364, 'Martinique', 'Martinique', 0, 'MQ', ''),
(365, 'Mauritius', 'Mauritius', 0, 'MU', ''),
(366, 'Mayotte', 'Mayotte', 0, 'YT', ''),
(367, 'Aguascalientes', 'Mexico', 0, 'MX', ''),
(368, 'Baja California Norte', 'Mexico', 0, 'MX', ''),
(369, 'Baja California Sur', 'Mexico', 0, 'MX', ''),
(370, 'Campeche', 'Mexico', 0, 'MX', ''),
(371, 'Chiapas', 'Mexico', 0, 'MX', ''),
(372, 'Chihuahua', 'Mexico', 0, 'MX', ''),
(373, 'Coahuila', 'Mexico', 0, 'MX', ''),
(374, 'Coalima', 'Mexico', 0, 'MX', ''),
(375, 'District Federal', 'Mexico', 0, 'MX', ''),
(376, 'Durango', 'Mexico', 0, 'MX', ''),
(377, 'Guanajuato', 'Mexico', 0, 'MX', ''),
(378, 'Guerrero', 'Mexico', 0, 'MX', ''),
(379, 'Hidalgo', 'Mexico', 0, 'MX', ''),
(380, 'Jalisco', 'Mexico', 0, 'MX', ''),
(381, 'Mexico', 'Mexico', 0, 'MX', ''),
(382, 'Morelos', 'Mexico', 0, 'MX', ''),
(383, 'Nayarit', 'Mexico', 0, 'MX', ''),
(384, 'Oaxaca', 'Mexico', 0, 'MX', ''),
(385, 'Puebla', 'Mexico', 0, 'MX', ''),
(386, 'Quintana Roo', 'Mexico', 0, 'MX', ''),
(387, 'Sinaloa', 'Mexico', 0, 'MX', ''),
(388, 'Sonora', 'Mexico', 0, 'MX', ''),
(389, 'Tabasco', 'Mexico', 0, 'MX', ''),
(390, 'Tamaulipas', 'Mexico', 0, 'MX', ''),
(391, 'Tlaxcala', 'Mexico', 0, 'MX', ''),
(392, 'Veracruz', 'Mexico', 0, 'MX', ''),
(393, 'Yucatan', 'Mexico', 0, 'MX', ''),
(394, 'Zacatecas', 'Mexico', 0, 'MX', ''),
(395, 'Moldavia', 'Moldavia', 0, 'MD', ''),
(396, 'Monaco', 'Monaco', 0, 'MC', ''),
(397, 'Mongolia', 'Mongolia', 0, '', ''),
(398, 'Montenegro', 'Montenegro', 0, 'ME', ''),
(399, 'Montserrat', 'Montserrat', 0, 'MS', ''),
(400, 'Morocco', 'Morocco', 0, 'MA', ''),
(401, 'Sidi Ifni (since 1969)', 'Morocco', 0, 'MA', ''),
(402, 'Spanish Morocco', 'Morocco', 0, 'MA', ''),
(403, 'Tangier (since 1956)', 'Morocco', 0, 'MA', ''),
(404, 'Mozambique', 'Mozambique', 0, 'MZ', ''),
(405, 'Myanmar', 'Myanmar', 0, 'MM', ''),
(406, 'Namibia', 'Namibia', 0, 'NA', ''),
(407, 'Nauru', 'Nauru', 0, 'NR', ''),
(408, 'Nepal', 'Nepal', 0, 'NP', ''),
(409, 'Netherlands', 'Netherlands', 1, 'NL', ''),
(410, 'Aruba Island', 'Netherlands-Antilles', 0, 'AN', ''),
(411, 'Bonaire Island', 'Netherlands-Antilles', 0, 'AN', ''),
(412, 'Cura ao Island', 'Netherlands-Antilles', 0, 'AN', ''),
(413, 'Saba Island', 'Netherlands-Antilles', 0, 'AN', ''),
(414, 'Sint Maarten Island', 'Netherlands-Antilles', 0, 'AN', ''),
(415, 'Hunter Island', 'New-Caledonia', 0, 'NC', ''),
(416, 'New Caledonia Island', 'New-Caledonia', 0, 'NC', ''),
(417, 'New-Caledonia', 'New-Caledonia', 0, 'NC', ''),
(418, 'Arapawa Island', 'New-Zealand', 0, 'NZ', ''),
(419, 'Campbell Island', 'New-Zealand', 0, 'NZ', ''),
(420, 'New-Zealand', 'New-Zealand', 0, 'NZ', ''),
(421, 'Nicaragua', 'Nicaragua', 0, 'NI', ''),
(422, 'Niger', 'Niger', 0, 'NE', ''),
(423, 'Nigeria', 'Nigeria', 0, 'NG', ''),
(424, 'Niue', 'Niue', 0, 'NU', ''),
(425, 'Norfolk-Island', 'Norfolk-Island', 0, 'NF', ''),
(426, 'Northern-Mariana-Islands', 'Northern-Mariana-Islands', 0, 'MP', ''),
(427, 'Aker-Shus', 'Norway', 0, 'NO', ''),
(428, 'Norway', 'Norway', 0, 'NO', ''),
(429, 'Oman', 'Oman', 0, 'OM', ''),
(430, 'Baluchistan', 'Pakistan', 0, 'PK', ''),
(431, 'Nothern Areas', 'Pakistan', 0, 'PK', ''),
(432, 'Pakistan', 'Pakistan', 0, 'PK', ''),
(433, 'Palau', 'Palau', 0, 'PW', ''),
(434, 'Panama', 'Panama', 0, 'PA', ''),
(435, 'Bismark Islands', 'Papua-New-Guinea', 0, 'PG', ''),
(436, 'Bougainville', 'Papua-New-Guinea', 0, 'PG', ''),
(437, 'd Entrecasteaux Islands', 'Papua-New-Guinea', 0, 'PG', ''),
(438, 'Feni Islands', 'Papua-New-Guinea', 0, 'PG', ''),
(439, 'Green Islands', 'Papua-New-Guinea', 0, 'PG', ''),
(440, 'Hermit Islands', 'Papua-New-Guinea', 0, 'PG', ''),
(441, 'Kaniet Islands', 'Papua-New-Guinea', 0, 'PG', ''),
(442, 'Lihir Islands', 'Papua-New-Guinea', 0, 'PG', ''),
(443, 'Louisiade Islands', 'Papua-New-Guinea', 0, 'PG', ''),
(444, 'Manus Island', 'Papua-New-Guinea', 0, 'PG', ''),
(445, 'Mussau Island', 'Papua-New-Guinea', 0, 'PG', ''),
(446, 'New Britain', 'Papua-New-Guinea', 0, 'PG', ''),
(447, 'New Guinea', 'Papua-New-Guinea', 0, 'PG', ''),
(448, 'New Hanover Island', 'Papua-New-Guinea', 0, 'PG', ''),
(449, 'New Ireland', 'Papua-New-Guinea', 0, 'PG', ''),
(450, 'Ninigo Islands', 'Papua-New-Guinea', 0, 'PG', ''),
(451, 'Nuguria Islands', 'Papua-New-Guinea', 0, 'PG', ''),
(452, 'Nukumanu Islands', 'Papua-New-Guinea', 0, 'PG', ''),
(453, 'Rossel Island', 'Papua-New-Guinea', 0, 'PG', ''),
(454, 'Tabar Islands', 'Papua-New-Guinea', 0, 'PG', ''),
(455, 'Tagula Island', 'Papua-New-Guinea', 0, 'PG', ''),
(456, 'Tanga Islands', 'Papua-New-Guinea', 0, 'PG', ''),
(457, 'Tauu Islands', 'Papua-New-Guinea', 0, 'PG', ''),
(458, 'Trobriand Island', 'Papua-New-Guinea', 0, 'PG', ''),
(459, 'Woodlark Island', 'Papua-New-Guinea', 0, 'PG', ''),
(460, 'Wuvulu Island', 'Papua-New-Guinea', 0, 'PG', ''),
(461, 'Paraguay', 'Paraguay', 0, 'PY', ''),
(462, 'Peru', 'Peru', 0, 'PE', ''),
(463, 'Philippines', 'Philippines', 0, 'PH', ''),
(464, 'Pitcairn', 'Pitcairn', 0, 'PN', ''),
(465, 'Austrian before 1918', 'Poland', 1, 'PL', ''),
(466, 'German (Prussian) before 1918', 'Poland', 1, 'PL', ''),
(467, 'German (Prussian) before 1944', 'Poland', 1, 'PL', ''),
(468, 'Poland', 'Poland', 1, 'PL', ''),
(469, 'Azores', 'Portugal', 0, 'PT', ''),
(470, 'Madeira Islands', 'Portugal', 0, 'PT', ''),
(471, 'Mainland Portugal', 'Portugal', 0, 'PT', ''),
(472, 'Portugal', 'Portugal', 1, 'PT', ''),
(473, 'Puerto-Rico', 'Puerto-Rico', 0, 'PR', ''),
(474, 'Qatar', 'Qatar', 0, 'QA', ''),
(475, 'Reunion', 'Reunion', 0, 'RE', ''),
(476, 'Romania', 'Romania', 1, 'RO', ''),
(477, 'Asian RSFSR', 'Russian-Federation', 0, 'RU', ''),
(478, 'European RSFSR', 'Russian-Federation', 0, 'RU', ''),
(479, 'Kaliningrad area', 'Russian-Federation', 0, 'RU', ''),
(480, 'Komandorskije Ostrova', 'Russian-Federation', 0, 'RU', ''),
(481, 'Kuril Islands', 'Russian-Federation', 0, 'RU', ''),
(482, 'Novaja Zeml area', 'Russian-Federation', 0, 'RU', ''),
(483, 'Novosibirskije Ostrova', 'Russian-Federation', 0, 'RU', ''),
(484, 'Ostrov Sachalin', 'Russian-Federation', 0, 'RU', ''),
(485, 'Russian-Federation', 'Russian-Federation', 0, 'RU', ''),
(486, 'Severnaja Zeml area', 'Russian-Federation', 0, 'RU', ''),
(487, 'Rwanda', 'Rwanda', 0, 'RW', ''),
(488, 'Bequia Island', 'Saint-Vincent-and-the-Grenadin', 0, 'VC', ''),
(489, 'Canouan Island', 'Saint-Vincent-and-the-Grenadin', 0, 'VC', ''),
(490, 'Carriacou Island', 'Saint-Vincent-and-the-Grenadin', 0, 'VC', ''),
(491, 'Saint Vincent Island', 'Saint-Vincent-and-the-Grenadin', 0, 'VC', ''),
(492, 'San-Marino', 'San-Marino', 0, 'SM', ''),
(493, 'Sao-Tome-and-Principe', 'Sao-Tome-and-Principe', 0, 'ST', ''),
(494, 'Saudi-Arabia', 'Saudi-Arabia', 0, 'SA', ''),
(495, 'Senegal', 'Senegal', 0, 'SN', ''),
(496, 'Serbia', 'Serbia', 0, 'RS', ''),
(497, 'Seychelles', 'Seychelles', 0, 'SC', ''),
(498, 'Sierra-Leone', 'Sierra-Leone', 0, 'SL', ''),
(499, 'Singapore', 'Singapore', 0, 'SG', ''),
(500, 'Slovakia', 'Slovakia', 1, 'SK', ''),
(501, 'Slovenia', 'Slovenia', 1, 'SI', ''),
(502, 'Choiseul', 'Solomon-Islands', 0, 'SB', ''),
(503, 'Guadalcanal', 'Solomon-Islands', 0, 'SB', ''),
(504, 'Malaita', 'Solomon-Islands', 0, 'SB', ''),
(505, 'New Georgia', 'Solomon-Islands', 0, 'SB', ''),
(506, 'San Cristobal', 'Solomon-Islands', 0, 'SB', ''),
(507, 'Santa Isabel', 'Solomon-Islands', 0, 'SB', ''),
(508, 'Somalia', 'Somalia', 0, 'SO', ''),
(509, 'Eastern Cape', 'South-Africa', 0, 'ZA', ''),
(510, 'Kwazulu-Natal', 'South-Africa', 0, 'ZA', ''),
(511, 'Mpumalanga', 'South-Africa', 0, 'ZA', ''),
(512, 'South-Africa', 'South-Africa', 0, 'ZA', ''),
(513, 'South-Georgia', 'South-Georgia', 0, '', ''),
(514, 'Balearic Islands', 'Spain', 0, 'ES', ''),
(515, 'Canary Islands', 'Spain', 1, 'ES', ''),
(516, 'Mainland', 'Spain', 1, 'ES', ''),
(517, 'Spain', 'Spain', 1, 'ES', ''),
(518, 'Spanish Morocco', 'Spain', 1, 'ES', ''),
(519, 'Sri-Lanka', 'Sri-Lanka', 0, 'LK', ''),
(520, 'St.-Kitts-and-Nevis', 'St.-Kitts-and-Nevis', 0, 'KN', ''),
(521, 'St.-Lucia', 'St.-Lucia', 0, 'LC', ''),
(522, 'St.-Pierre-and-Miquelon', 'St.-Pierre-and-Miquelon', 0, 'PM', ''),
(523, 'Sudan', 'Sudan', 0, 'SD', ''),
(524, 'Suriname', 'Suriname', 0, 'SR', ''),
(525, 'Swaziland', 'Swaziland', 0, 'SZ', ''),
(526, 'Sweden', 'Sweden', 1, 'SE', ''),
(527, 'Switzerland', 'Switzerland', 0, 'CH', ''),
(528, 'Syrian-Arab-Republic', 'Syrian-Arab-Republic', 0, 'SY', ''),
(529, 'Taiwan', 'Taiwan', 0, 'TW', ''),
(530, 'Tajikistan', 'Tajikistan', 0, 'TJ', ''),
(531, 'Tanzania', 'Tanzania', 0, 'TZ', ''),
(532, 'Thailand', 'Thailand', 0, 'TH', ''),
(533, 'The-Gambia', 'The-Gambia', 0, 'GM', ''),
(534, 'Togo', 'Togo', 0, 'TG', ''),
(535, 'Tokelau', 'Tokelau', 0, 'TK', ''),
(536, 'Ata Island', 'Tonga', 0, 'TO', ''),
(537, 'Eua Island', 'Tonga', 0, 'TO', ''),
(538, 'Tafahi Island', 'Tonga', 0, 'TO', ''),
(539, 'Toku Island', 'Tonga', 0, 'TO', ''),
(540, 'Tongatapu Islands', 'Tonga', 0, 'TO', ''),
(541, 'Vava u Islands', 'Tonga', 0, 'TO', ''),
(542, 'Tobago', 'Trinidad-and-Tobago', 0, 'TT', ''),
(543, 'Trinidad', 'Trinidad-and-Tobago', 0, 'TT', ''),
(544, 'Trinidad-and-Tobago', 'Trinidad-and-Tobago', 0, 'TT', ''),
(545, 'Tunisia', 'Tunisia', 0, 'TN', ''),
(546, 'Asian', 'Turkey', 0, 'TR', ''),
(547, 'European', 'Turkey', 0, 'TR', ''),
(548, 'Turkey', 'Turkey', 0, 'TR', ''),
(549, 'Turkmenistan', 'Turkmenistan', 0, 'TM', ''),
(550, 'Turks-and-Caicos-Islands', 'Turks-and-Caicos-Islands', 0, 'TC', ''),
(551, 'Tuvalu', 'Tuvalu', 0, 'TV', ''),
(552, 'Uganda', 'Uganda', 0, 'UG', ''),
(553, 'Ukraine', 'Ukraine', 0, 'UA', ''),
(554, 'United-Arab-Emirates', 'United-Arab-Emirates', 0, 'AE', ''),
(555, 'Alabama', 'United-States', 0, 'US', 'AL'),
(556, 'Alaska', 'United-States', 0, 'US', 'AK'),
(557, 'Arizona', 'United-States', 0, 'US', 'AZ'),
(558, 'Arkansas', 'United-States', 0, 'US', 'AR'),
(559, 'California', 'United-States', 0, 'US', 'CA'),
(560, 'Colorado', 'United-States', 0, 'US', 'CO'),
(561, 'Connecticut', 'United-States', 0, 'US', 'CT'),
(562, 'Delaware', 'United-States', 0, 'US', 'DE'),
(563, 'District of Columbia', 'United-States', 0, 'US', 'DC'),
(564, 'Florida', 'United-States', 0, 'US', 'FL'),
(565, 'Georgia', 'United-States', 0, 'US', 'GA'),
(566, 'Hawaii', 'United-States', 0, 'US', 'HI'),
(567, 'Idaho', 'United-States', 0, 'US', 'ID'),
(568, 'Illinois', 'United-States', 0, 'US', 'IL'),
(569, 'Indiana', 'United-States', 0, 'US', 'IN'),
(570, 'Iowa', 'United-States', 0, 'US', 'IA'),
(571, 'Kansas', 'United-States', 0, 'US', 'KS'),
(572, 'Kentucky', 'United-States', 0, 'US', 'KY'),
(573, 'Louisiana', 'United-States', 0, 'US', 'LA'),
(574, 'Maine', 'United-States', 0, 'US', 'ME'),
(575, 'Maryland', 'United-States', 0, 'US', 'MD'),
(576, 'Massachusetts', 'United-States', 0, 'US', 'MA'),
(577, 'Michigan', 'United-States', 0, 'US', 'MI'),
(578, 'Minnesota', 'United-States', 0, 'US', 'MN'),
(579, 'Mississippi', 'United-States', 0, 'US', 'MS'),
(580, 'Missouri', 'United-States', 0, 'US', 'MO'),
(581, 'Montana', 'United-States', 0, 'US', 'MT'),
(582, 'Nebraska', 'United-States', 0, 'US', 'NE'),
(583, 'Nevada', 'United-States', 0, 'US', 'NV'),
(584, 'New Hampshire', 'United-States', 0, 'US', 'NH'),
(585, 'New Jersey', 'United-States', 0, 'US', 'NJ'),
(586, 'New Mexico', 'United-States', 0, 'US', 'NM'),
(587, 'New York', 'United-States', 0, 'US', 'NY'),
(588, 'North Carolina', 'United-States', 0, 'US', 'NC'),
(589, 'North Dakota', 'United-States', 0, 'US', 'ND'),
(590, 'Ohio', 'United-States', 0, 'US', 'OH'),
(591, 'Oklahoma', 'United-States', 0, 'US', 'OK'),
(592, 'Oregon', 'United-States', 0, 'US', 'OR'),
(593, 'Pennsylvania', 'United-States', 0, 'US', 'PA'),
(594, 'Rhode Island', 'United-States', 0, 'US', 'RI'),
(595, 'South Carolina', 'United-States', 0, 'US', 'SC'),
(596, 'South Dakota', 'United-States', 0, 'US', 'SD'),
(597, 'Tennessee', 'United-States', 0, 'US', 'TN'),
(598, 'Texas', 'United-States', 0, 'US', 'TX'),
(599, 'United-States', 'United-States', 0, 'US', ''),
(600, 'Utah', 'United-States', 0, 'US', 'UT'),
(601, 'Vermont', 'United-States', 0, 'US', 'VT'),
(602, 'Virginia', 'United-States', 0, 'US', 'VA'),
(603, 'Washington', 'United-States', 0, 'US', 'WA'),
(604, 'West Virginia', 'United-States', 0, 'US', 'WV'),
(605, 'Wisconsin', 'United-States', 0, 'US', 'WI'),
(606, 'Wyoming', 'United-States', 0, 'US', 'WY'),
(607, 'Uruguay', 'Uruguay', 0, 'UY', ''),
(608, 'Uzbekistan', 'Uzbekistan', 0, 'UZ', ''),
(609, 'Ambrim Island', 'Vanuatu', 0, 'VU', ''),
(610, 'Aneityum Island', 'Vanuatu', 0, 'VU', ''),
(611, 'Efate Island', 'Vanuatu', 0, 'VU', ''),
(612, 'Epi Island', 'Vanuatu', 0, 'VU', ''),
(613, 'Eromanga Island', 'Vanuatu', 0, 'VU', ''),
(614, 'Espritu Santo Island', 'Vanuatu', 0, 'VU', ''),
(615, 'Maewo Island', 'Vanuatu', 0, 'VU', ''),
(616, 'Malekula Island', 'Vanuatu', 0, 'VU', ''),
(617, 'Oba Island', 'Vanuatu', 0, 'VU', ''),
(618, 'Pentecost Island', 'Vanuatu', 0, 'VU', ''),
(619, 'Santa Maria Island', 'Vanuatu', 0, 'VU', ''),
(620, 'Tana Island', 'Vanuatu', 0, 'VU', ''),
(621, 'Torres Islands', 'Vanuatu', 0, 'VU', ''),
(622, 'Vanua Lava Island', 'Vanuatu', 0, 'VU', ''),
(623, 'Vanuatu', 'Vanuatu', 0, 'VU', ''),
(624, 'Venezuela', 'Venezuela', 0, 'VE', ''),
(625, 'North Vietnam', 'Viet-Nam', 0, 'VN', ''),
(626, 'South Vietnam', 'Viet-Nam', 0, 'VN', ''),
(627, 'Viet-Nam', 'Viet-Nam', 0, 'VN', ''),
(628, 'Virgin-Islands-(U.K.)', 'Virgin-Islands-(U.K.)', 0, '', ''),
(629, 'Virgin-Islands-(U.S.)', 'Virgin-Islands-(U.S.)', 0, 'VI', ''),
(630, 'Wallis-and-Futanu-Islands', 'Wallis-and-Futanu-Islands', 0, 'WF', ''),
(631, 'Savai i', 'Western-Samoa', 0, '', ''),
(632, 'Upolu', 'Western-Samoa', 0, '', ''),
(633, 'Yemen', 'Yemen', 0, 'YE', ''),
(634, 'Yugoslavia', 'Yugoslavia', 0, 'YU', ''),
(635, 'Zaire', 'Zaire', 0, 'ZR', ''),
(636, 'Zambia', 'Zambia', 0, 'ZM', ''),
(637, 'Zimbabwe', 'Zimbabwe', 0, 'ZW', ''),
(638, 'Bedfordshire', 'UK-England', 1, 'UK', ''),
(639, 'Berkshire', 'UK-England', 1, 'UK', ''),
(640, 'Buckinghamshire', 'UK-England', 1, 'UK', ''),
(641, 'Cambridgeshire', 'UK-England', 1, 'UK', ''),
(642, 'Cheshire', 'UK-England', 1, 'UK', ''),
(643, 'Cornwall', 'UK-England', 1, 'UK', ''),
(644, 'Cumberland', 'UK-England', 1, 'UK', ''),
(645, 'Derbyshire', 'UK-England', 1, 'UK', ''),
(646, 'Devon', 'UK-England', 1, 'UK', ''),
(647, 'Dorset', 'UK-England', 1, 'UK', ''),
(648, 'Durham', 'UK-England', 1, 'UK', ''),
(649, 'Essex', 'UK-England', 1, 'UK', ''),
(650, 'Gloucestershire', 'UK-England', 1, 'UK', ''),
(651, 'Hampshire', 'UK-England', 1, 'UK', ''),
(652, 'Herefordshire', 'UK-England', 1, 'UK', ''),
(653, 'Hertfordshire', 'UK-England', 1, 'UK', ''),
(654, 'Huntingdonshire', 'UK-England', 1, 'UK', ''),
(655, 'Kent', 'UK-England', 1, 'UK', ''),
(656, 'Lancashire', 'UK-England', 1, 'UK', ''),
(657, 'Leicestershire', 'UK-England', 1, 'UK', ''),
(658, 'Lincolnshire', 'UK-England', 1, 'UK', ''),
(659, 'Middlesex', 'UK-England', 1, 'UK', ''),
(660, 'Norfolk', 'UK-England', 1, 'UK', ''),
(661, 'Northamptonshire', 'UK-England', 1, 'UK', ''),
(662, 'Northumberland', 'UK-England', 1, 'UK', ''),
(663, 'Nottinghamshire', 'UK-England', 1, 'UK', ''),
(664, 'Oxfordshire', 'UK-England', 1, 'UK', ''),
(665, 'Rutland', 'UK-England', 1, 'UK', ''),
(666, 'Shropshire', 'UK-England', 1, 'UK', ''),
(667, 'Somerset', 'UK-England', 1, 'UK', ''),
(668, 'Staffordshire', 'UK-England', 1, 'UK', ''),
(669, 'Suffolk', 'UK-England', 1, 'UK', ''),
(670, 'Surrey', 'UK-England', 1, 'UK', ''),
(671, 'Sussex', 'UK-England', 1, 'UK', ''),
(672, 'Warwickshire', 'UK-England', 1, 'UK', ''),
(673, 'Westmorland', 'UK-England', 1, 'UK', ''),
(674, 'Wiltshire', 'UK-England', 1, 'UK', ''),
(675, 'Worcestershire', 'UK-England', 1, 'UK', ''),
(676, 'Yorkshire', 'UK-England', 1, 'UK', ''),
(677, 'Anglesey-Sir Fon', 'UK-Wales(inc. Monmouthshire)', 1, 'UK', ''),
(678, 'Brecknockshire-Sir Frycheiniog', 'UK-Wales(inc. Monmouthshire)', 1, 'UK', ''),
(679, 'Caernarfonshire-Sir Gaernarfon', 'UK-Wales(inc. Monmouthshire)', 1, 'UK', ''),
(680, 'Carmarthenshire-Sir Gaerfyrddin', 'UK-Wales(inc. Monmouthshire)', 1, 'UK', ''),
(681, 'Cardiganshire-Ceredigion', 'UK-Wales(inc. Monmouthshire)', 1, 'UK', ''),
(682, 'Denbighshire-Sir Ddinbych', 'UK-Wales(inc. Monmouthshire)', 1, 'UK', ''),
(683, 'Flintshire-Sir Fflint', 'UK-Wales(inc. Monmouthshire)', 1, 'UK', ''),
(684, 'Glamorgan-Morgannwg', 'UK-Wales(inc. Monmouthshire)', 1, 'UK', ''),
(685, 'Merioneth-Meirionnydd', 'UK-Wales(inc. Monmouthshire)', 1, 'UK', ''),
(686, 'Monmouthshire-Sir Fynwy', 'UK-Wales(inc. Monmouthshire)', 1, 'UK', ''),
(687, 'Montgomeryshire-Sir Drefaldwyn', 'UK-Wales(inc. Monmouthshire)', 1, 'UK', ''),
(688, 'Pembrokeshire-Sir Benfro', 'UK-Wales(inc. Monmouthshire)', 1, 'UK', ''),
(689, 'Radnorshire-Sir Faesyfed', 'UK-Wales(inc. Monmouthshire)', 1, 'UK', ''),
(690, 'Aberdeenshire', 'UK-Scotland', 1, 'UK', ''),
(691, 'Angus-Forfarshire', 'UK-Scotland', 1, 'UK', ''),
(692, 'Argyllshire', 'UK-Scotland', 1, 'UK', ''),
(693, 'Ayrshire', 'UK-Scotland', 1, 'UK', ''),
(694, 'Banffshire', 'UK-Scotland', 1, 'UK', ''),
(695, 'Berwickshire', 'UK-Scotland', 1, 'UK', ''),
(696, 'Buteshire', 'UK-Scotland', 1, 'UK', ''),
(697, 'Cromartyshire', 'UK-Scotland', 1, 'UK', ''),
(698, 'Caithness', 'UK-Scotland', 1, 'UK', ''),
(699, 'Clackmannanshire', 'UK-Scotland', 1, 'UK', ''),
(700, 'Dumfriesshire', 'UK-Scotland', 1, 'UK', ''),
(701, 'Dunbartonshire-Dumbartonshire', 'UK-Scotland', 1, 'UK', ''),
(702, 'East Lothian-Haddingtonshire', 'UK-Scotland', 1, 'UK', ''),
(703, 'Fife', 'UK-Scotland', 1, 'UK', ''),
(704, 'Inverness-shire', 'UK-Scotland', 1, 'UK', ''),
(705, 'Kincardineshire', 'UK-Scotland', 1, 'UK', ''),
(706, 'Kinross-shire', 'UK-Scotland', 1, 'UK', ''),
(707, 'Kirkcudbrightshire', 'UK-Scotland', 1, 'UK', ''),
(708, 'Lanarkshire', 'UK-Scotland', 1, 'UK', ''),
(709, 'Midlothian-Edinburghshire', 'UK-Scotland', 1, 'UK', ''),
(710, 'Morayshire', 'UK-Scotland', 1, 'UK', ''),
(711, 'Nairnshire', 'UK-Scotland', 1, 'UK', ''),
(712, 'Orkney', 'UK-Scotland', 1, 'UK', ''),
(713, 'Peeblesshire', 'UK-Scotland', 1, 'UK', ''),
(714, 'Perthshire', 'UK-Scotland', 1, 'UK', ''),
(715, 'Renfrewshire', 'UK-Scotland', 1, 'UK', ''),
(716, 'Ross-shire', 'UK-Scotland', 1, 'UK', ''),
(717, 'Roxburghshire', 'UK-Scotland', 1, 'UK', ''),
(718, 'Selkirkshire', 'UK-Scotland', 1, 'UK', ''),
(719, 'Shetland', 'UK-Scotland', 1, 'UK', ''),
(720, 'Stirlingshire', 'UK-Scotland', 1, 'UK', ''),
(721, 'Sutherland', 'UK-Scotland', 1, 'UK', ''),
(722, 'West Lothian-Linlithgowshire', 'UK-Scotland', 1, 'UK', ''),
(723, 'Wigtownshire', 'UK-Scotland', 1, 'UK', ''),
(724, 'Antrim', 'UK-Northern Ireland', 1, 'UK', ''),
(725, 'Armagh', 'UK-Northern Ireland', 1, 'UK', ''),
(726, 'Down', 'UK-Northern Ireland', 1, 'UK', ''),
(727, 'Fermanagh', 'UK-Northern Ireland', 1, 'UK', ''),
(728, 'Londonderry', 'UK-Northern Ireland', 1, 'UK', ''),
(729, 'Tyrone', 'UK-Northern Ireland', 1, 'UK', '');
