<?php
/**
 * @package    com_quix
 * @author     ThemeXpert <info@themexpert.com>
 * @copyright  Copyright (C) 2015. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;

abstract class ModQuixMenuHelper {
	private $titles;
	private $links;
	private $getArrayClasses;

	public static function getQuixComponent($authCheck = true) {

		if(!JComponentHelper::isEnabled('com_quix')) return NULL;
		$menuitems = new StdClass();
		$menuitems->text = JText::_('COM_QUIX');
		$menuitems->submenu = new StdClass();
		$titles = self::getArraytitle();
		$links = self::getArrayLinks();

		for($i=0;$i<count(self::getArraytitle());$i++)
		{
			$menuitems->submenu->$i = new StdClass();
			$menuitems->submenu->$i->text = $titles[$i];
			$menuitems->submenu->$i->link = $links[$i];

			$child = self::checkChild($links[$i]);
			if($child){
				$menuitems->submenu->$i->child = true;
				$menuitems->submenu->$i->childitems = self::getChild($links[$i]);
			}else{
				$menuitems->submenu->$i->child = false;
			}
		}
		
		return $menuitems;
	}

	public static function checkChild($link){
		return false;
	}
	
	public static function getChild($link){
		return;
	}


	public static function getArraytitle(){
		return array(
			0 => JText::_('MOD_QUIX_MENU_ADD_NEW'),
			1 => JText::_('MOD_QUIX_MENU_PAGES'),
			2 => JText::_('MOD_QUIX_MENU_COLLECTIONS')
		);
	}

	static public function getArrayLinks(){
		return array(
			0 => 'index.php?option=com_quix&task=page.add',
			1 => 'index.php?option=com_quix',
			2 => 'index.php?option=com_quix&view=collections'
		);
	}

}
