<?php
/**
 * @package		DigiCom
 * @author 		ThemeXpert http://www.themexpert.com
 * @copyright	Copyright (c) 2010-2015 ThemeXpert. All rights reserved.
 * @license 	GNU General Public License version 3 or later; see LICENSE.txt
 * @since 		1.0.0
 */

defined('_JEXEC') or die;
$configs = $this->configs;
$images  = json_decode($this->item->images);
// Legacy code
// TODO : Remove after 1.1
if(!isset($images->image_full)){
	$images = new stdClass();
	$images->image_full = $this->item->images;
}elseif(empty($images->image_full)){
	$images->image_full = $images->image_intro;
}
if($this->item->price > 0){
	$price = DigiComSiteHelperPrice::format_price($this->item->price, $configs->get('currency','USD'), true, $configs).'</span>';
}else{
	$price = '<span>'.JText::_('COM_DIGICOM_PRODUCT_PRICE_FREE').'</span>';
}
$link = JRoute::_(DigiComSiteHelperRoute::getProductRoute($this->item->id, $this->item->catid, $this->item->language));
?>

<div id="digicom" class="dc dc-product" itemscope itemtype="http://schema.org/CreativeWork">

	<header class="dc-item-head">
		<h1 class="dc-product-title">
			<span itemprop="name">
				<?php echo $this->item->name; ?>
			</span>
		</h1>
		<?php echo $this->item->event->afterDisplayTitle; ?>

	</header>

	<article class="container-fluid">
		<div class="row">
			<div class="col-md-<?php echo ($this->item->params->get('show_sidebar', 1) ? 8 : 12); ?>">
				<?php if(!$this->item->params->get('show_image', 1)): ?>
					<?php if(!empty($images->image_full)): ?>
					<div class="dc-item-in">
							<figure>
								<img itemprop="image" src="<?php echo JURI::root().$images->image_full; ?>" alt="<?php echo $this->item->name; ?>" class="dc-product-image"/>
							</figure>
					</div>
					<?php endif; ?>
				<?php endif; ?>

				<?php // Content is generated by content plugin event "onContentBeforeDisplay" ?>
				<?php echo $this->item->event->beforeDisplayContent; ?>

				<div class="dc-product-details" itemprop="description">
					<?php echo $this->item->text; ?>
				</div>

				<?php echo $this->item->event->afterDisplayContent; ?>

				<?php if(!$this->item->params->get('show_sidebar', 1)): ?>
					<?php echo $this->loadTemplate('cart'); ?>
				<?php endif; ?>
					
				
			</div>
			<?php if($this->item->params->get('show_sidebar', 1)): ?>
			<div class="col-md-4">
				<div class="dc-item-in">
					<?php if($this->item->featured):?>
						<!-- Featured label -->
						<span class="label label-info label-featured"><?php echo JText::_('JFEATURED');?></span>
					<?php endif; ?>
					
					<?php if(!$configs->get('catalogue', 0) && $this->item->params->get('show_price', 1)): ?>
					<div class="well clearfix" itemprop="offers" itemscope itemtype="http://schema.org/Offer">
						<div class="container-fluid">
							<div class="row">
								<div class="col-md-12">
										
									<p class="dc-product-price text-center">
										<meta itemprop="priceCurrency" content="<?php echo $configs->get('currency','USD');?>" />
										<strong itemprop="price" content="<?php echo $this->item->price; ?>">
											<?php echo $price; ?>
										</strong>
									</p>								

									<?php if($configs->get('enable_taxes', 0) && $configs->get('display_tax_with_price','0')):?>
										<div class="dc-product-tax text-info text-center">
											<?php echo JLayoutHelper::render('tax.price', array('config' => $configs, 'item' => $this->item)); ?>
										</div>
									<?php endif; ?>

									<?php if ($this->configs->get('show_validity',1) == 1) : ?>
									<div class="col-md-12">
										<div class="dc-product-validity text-muted text-center">
											<?php echo JText::_('COM_DIGICOM_PRODUCT_VALIDITY'); ?> : <?php echo DigiComSiteHelperPrice::getProductValidityPeriod($this->item); ?>
										</div>
									</div>
									<?php endif; ?>

								</div>
							</div>
						</div>
					</div>
					<?php endif; ?>

					<?php if($this->item->params->get('show_productinfo', 1)): ?>
					<div class="dc-product-info">
						<ul class="list-unstyled no-margin">
							<?php if($this->item->params->get('show_created', 1)): ?>
							<li>
								<strong><?php echo JText::_('COM_DIGICOM_PRODUCT_CREATE_DATE');?> :</strong> <?php echo JFactory::getDate($this->item->publish_up)->format('M d, Y')?>
							</li>
							<?php endif; ?>
							<?php if($this->item->params->get('show_category', 1)): ?>
							<li>
								<strong><?php echo JText::_('COM_DIGICOM_PRODUCT_CATEGORY');?>: </strong>
								<a href="<?php echo DigiComSiteHelperRoute::getCategoryRoute($this->item->catid);?>">
									<?php echo $this->item->category_title;?></a>
							</li>
							<?php endif; ?>
							<?php if($this->item->params->get('show_type', 1)): ?>
							<li>
								<strong><?php echo JText::_('COM_DIGICOM_TYPE');?> : </strong>
								<?php if(!empty($this->item->bundle_source)):?>
									<?php echo JText::_('COM_DIGICOM_PRODUCT_TYPE_BUNDLE');?>
								<?php else:?>
									<?php echo JText::_('COM_DIGICOM_PRODUCT_TYPE_SINGLE');?>
								<?php endif; ?>
							</li>
							<?php endif; ?>
							<?php if($this->item->params->get('show_tags', 1)): ?>
							<li>
								<strong><?php echo JText::_('COM_DIGICOM_TAGS');?> :</strong> <?php
									if(!empty($this->item->tags->itemTags)){
										$this->item->tagLayout = new JLayoutFile('joomla.content.tags');
										echo $this->item->tagLayout->render($this->item->tags->itemTags);
									}
								?>
							</li>
							<?php endif; ?>
						</ul>
					</div>
					<?php endif; ?>

					<?php echo $this->loadTemplate('cart'); ?>

				</div>

				<?php echo $this->loadTemplate('bundle');  ?>

			</div>

			<?php endif; ?>

		</div>
	</article>

	<?php
		if($configs->get('afteradditem',0) == "2"):
			$layoutData = array(
				'selector' => 'digicomCartPopup',
				'params'   => array(
												'title' 	=> JText::_('COM_DIGICOM_CART_ITEMS'),
												'height' 	=> '400',
												'width'	 	=> '1280',
												'footer'	=> '<button type="button" class="btn btn-default" data-dismiss="modal">'.JText::_('COM_DIGICOM_CONTINUE').'</button> <a href="'.JRoute::_("index.php?option=com_digicom&view=cart").'" class="btn btn-success"><i class="ico-ok-sign"></i> '.JText::_("COM_DIGICOM_CHECKOUT").'</a>'
											),
				'body'     => ''
			);
			echo JLayoutHelper::render('bt3.modal.main', $layoutData);
		endif;
	?>

	<?php echo DigiComSiteHelperDigicom::powered_by(); ?>

</div>
