<?php
  // HTML class
  $classes = classNames( "qx-element qx-element-{$type} {$field['class']}", $visibilityClasses);

  $animation_class = ($field['animation']) ? 'wow ' . $field['animation'] : '';
  // Hover animation
  $hover_animation = ($field['hover_animation']) ? " qx-hvr-{$field['hover_animation']}" : '' ;
  $animation_delay = (array_key_exists('animation_delay', $field)) ? $field['animation_delay'] : '';
  // css
  Assets::Css('qx-slick', QUIX_URL."/assets/css/slick.css");
  // JS script
  Assets::Js('qx-slick', QUIX_URL."/assets/js/slick.min.js");
  // RTL detection
  $direction = Jfactory::getDocument()->direction;
  
  // Responsive fields + Legacy check
  // Slide
  if( preg_match('/responsive_preview/i', $field['slides_count']) ){
    $slide = json_decode($field['slides_count']);
    // Slide To Show
    $slide_count_desktop = $slide->desktop;
    $slide_count_tablet = $slide->tablet;
    $slide_count_phone = $slide->phone;
  }else{
    $slide_count_desktop = $slide_count_tablet = $slide_count_phone = $field['slides_count'];
  }
  // Scroll
  if( preg_match('/responsive_preview/i', $field['slides_scroll']) ){
    $scroll = json_decode( $field['slides_scroll']);
    $scroll_count_desktop = $scroll->desktop;
    $scroll_count_tablet = $scroll->tablet;
    $scroll_count_phone = $scroll->phone;
  }else{
    $scroll_count_desktop = $scroll_count_tablet = $scroll_count_phone = $field['slides_scroll'];
  }
  
  $script = array();
  $script[] = 'slidesToShow: ' . $slide_count_desktop;
  $script[] = 'slidesToScroll: ' . $scroll_count_desktop;
  $script[] = ($field['arrows']) ? 'arrows:true' : 'arrows:false';
  $script[] = ($field['dots']) ? 'dots:true' : 'dots:false';
  $script[] = ($field['autoplay']) ? 'autoplay:true' : 'autoplay:false';
  $script[] = 'autoplaySpeed:' . $field['autoplay_speed'];
  $script[] = 'infinite: true';
  if( 'rtl' == $direction ){ $script[] = 'rtl:true'; }
  $script[] = 'responsive:[
    { breakpoint: 768, settings: { slidesToShow: '. $slide_count_tablet .',  slidesToScroll: ' . $scroll_count_tablet . '} },
    { breakpoint: 480, settings: { slidesToShow: '. $slide_count_phone .', slidesToScroll: '. $scroll_count_phone .' } }
  ]';
?>
<div id="<?php echo $id; ?>" class="<?php echo $classes; ?>" dir="<?php echo $direction; ?>">
    <?php foreach( $field['carousels'] as $carousel ):?>
      <?php $animation_delay += 0.1;?>
      <div class="qx-carousel-item <?php echo $animation_class . $hover_animation?>" 
        <?php echo ($field['animation']) ? 'data-wow-delay="'. $animation_delay .'s"' : '';?> >

        <?php if( $carousel['link']['url'] ):?>
          <a href="<?php echo $carousel['link']['url'] ?>" <?php echo ( $carousel['link']['target'] ) ? ' target="_blank" rel="noopener noreferrer"' : '' ?> >
        <?php endif;?>
          <img class="<?php echo $field['image_style']?>" src="<?php echo $carousel['image']?>" alt="<?php echo $carousel['title']?>">
        <?php if( $carousel['link']['url'] ):?>
          </a>
        <?php endif;?>
        <?php if( $field['enable_title_caption'] ):?>
          <h4 class="qx-carousel-title"><?php echo $carousel['title']?></h4>
          <div class="qx-carousel-caption"><?php echo $carousel['caption']?></div>
        <?php endif;?>
      </div>
    <?php endforeach;?>
</div>

<?php
  Assets::js( 'qx-carousel-'. $id, QUIX_ELEMENTS_PATH . '/carousel/inline-js.php', compact(['id', 'script']), ['qx-slick']);
?>
<!-- qx-element-carousel -->